<?php
// Tentukan folder upload
$targetDir = "uploads/";
if (!is_dir($targetDir)) {
    mkdir($targetDir, 0755, true);
}

// Periksa apakah file telah diupload
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $fileName = basename($_FILES["image"]["name"]);
    $targetFilePath = $targetDir . $fileName;
    $fileType = strtolower(pathinfo($targetFilePath, PATHINFO_EXTENSION));

    // Validasi file
    $allowedTypes = array("jpg", "jpeg", "png", "gif");
    if (in_array($fileType, $allowedTypes)) {
        // Validasi ukuran file (maks. 2MB)
        if ($_FILES["image"]["size"] <= 2097152) {
            // Pindahkan file ke folder upload
            if (move_uploaded_file($_FILES["image"]["tmp_name"], $targetFilePath)) {
                echo "<h1>Gambar berhasil diupload!</h1>";
                echo "<p><a href='$targetFilePath' target='_blank'>Lihat Gambar</a></p>";
            } else {
                echo "<h1>Terjadi kesalahan saat mengupload gambar.</h1>";
            }
        } else {
            echo "<h1>Ukuran file terlalu besar. Maksimal 2MB.</h1>";
        }
    } else {
        echo "<h1>Format file tidak didukung. Hanya JPG, JPEG, PNG, dan GIF.</h1>";
    }
} else {
    echo "<h1>Tidak ada file yang diupload.</h1>";
}
?>
