<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Document Reader</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
    <div class="container">
        <h1>Document Reader</h1>
        <p>Daftar dokumen tersedia:</p>
        <ul>
            <?php
            // Folder tempat file disimpan
            $folder = "docs/";

            // Periksa apakah folder ada
            if (is_dir($folder)) {
                // Ambil semua file dalam folder
                $files = array_diff(scandir($folder), array('.', '..'));

                // Tampilkan file dalam daftar
                foreach ($files as $file) {
                    $supportedExtensions = ["txt", "pdf", "doc", "docx", "xls", "xlsx", "csv", "html", "htm"];
                    $fileExtension = strtolower(pathinfo($file, PATHINFO_EXTENSION));

                    // Filter file yang didukung
                    if (in_array($fileExtension, $supportedExtensions)) {
                        echo "<li><a href='view.php?file=" . urlencode($file) . "'>" . htmlspecialchars($file) . "</a></li>";
                    }
                }
            } else {
                echo "<li>Folder dokumen tidak ditemukan.</li>";
            }
            ?>
        </ul>
    </div>
</body>
</html>
